/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.VWScenarioInputFields;
import filenet.sim.api.VWScenarioXMLHandler;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.base.VWString;
import java.io.Serializable;

public final class VWScenarioInputField
implements Serializable,
Comparable {
    private VWScenarioInputFields m_parent = null;
    private String m_fieldName = null;
    private boolean m_isRange = false;
    private VWFieldDefinition m_fieldDefinition = null;

    protected VWScenarioInputField(String name, boolean isRange, VWScenarioInputFields parent) throws VWException {
        this.m_fieldDefinition = parent.getFieldAssignments().getStepSettings().getScenarioWorkflow().getWorkflowDefinition().getField(name);
        if (this.m_fieldDefinition.isArray()) {
            throw new VWException("sim.api.VWScenarioInputField.ArraysNotAllowedForInputFields", "Input fields can not be of array type.");
        }
        this.m_fieldName = name;
        this.m_isRange = isRange;
        this.m_parent = parent;
    }

    public String getFieldName() {
        return this.m_fieldName;
    }

    public void setFieldName(String name) throws VWException {
        if (this.m_parent.hasInputField(name)) {
            new VWException(new IllegalArgumentException(VWScenarioInputFields.StrFieldAlreadyExists.toString(name)));
        }
        if (name == null) {
            throw new NullPointerException();
        }
        this.m_fieldName = name;
    }

    public boolean getIsRange() {
        return this.m_isRange;
    }

    public void setIsRange(boolean isRange) {
        this.m_isRange = isRange;
    }

    public String toString() {
        return this.m_fieldName;
    }

    public int compareTo(Object o) {
        VWScenarioInputField inputField = (VWScenarioInputField)o;
        int cmp = this.getFieldName().compareTo(inputField.getFieldName());
        if (cmp != 0) {
            return cmp;
        }
        if (this.getIsRange() == inputField.getIsRange()) {
            return 0;
        }
        return this.getIsRange() ? 1 : 0;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    protected void setParent(VWScenarioInputFields parent) {
        this.m_parent = parent;
    }

    protected void toXML(StringBuffer buffer, String baseIndent) throws VWException {
        buffer.append(baseIndent + "<FieldInput ");
        buffer.append("Name=\"" + VWScenarioXMLHandler.toXMLString(this.getFieldName()) + "\" ");
        buffer.append("IsRange=\"" + (this.getIsRange() ? "TRUE" : "FALSE") + "\"/>\n");
    }

    protected boolean validate() throws VWException {
        try {
            this.m_fieldDefinition = null;
            this.getFieldDefinition();
        }
        catch (VWException e) {
            VWString theMessage = new VWString("sim.api.VWScenarioFieldAssignments.InvalidInputField", "Field Assignments: Invalid input field ''{1}'':", this.getFieldName());
            this.m_parent.getFieldAssignments().addValidationError(theMessage.toString() + " " + e.getLocalizedMessage(), -1);
            return false;
        }
        return true;
    }

    protected VWFieldDefinition getFieldDefinition() throws VWException {
        if (this.m_fieldDefinition == null) {
            this.m_fieldDefinition = this.m_parent.getFieldAssignments().getStepSettings().getScenarioWorkflow().getWorkflowDefinition().getField(this.getFieldName());
        }
        return this.m_fieldDefinition;
    }
}

